//+------------------------------------------------------------------+
//|                                             Trendy Dashboard.mq4 |
//|                                  Copyright  2010, Steve Hopwood |
//|                              http://www.hopwood3.freeserve.co.uk |
//+------------------------------------------------------------------+
#property copyright "Copyright  2010, Steve Hopwood"
#property link      "http://www.hopwood3.freeserve.co.uk"

#property indicator_chart_window

#define  up "Up"
#define  down "Down"
#define  ranging "Range"
#define  up "Up"
#define  down "Down"
#define  none "None"


extern string	pd="----Trad pair inputs----";
extern string	PairsToTrade = "AUDCAD,AUDCHF,AUDJPY,AUDNZD,AUDUSD,CADCHF,CADJPY,CHFJPY,EURAUD,EURCAD,EURCHF,EURGBP,EURJPY,EURNZD,EURUSD,GBPCHF,GBPJPY,GBPUSD,NZDJPY,NZDUSD,USDCAD,USDCHF,USDJPY";
extern bool    ShowRangingPairs=false;

//MA. Rising MA the trend is up and vice-versa
extern string  sima="Trend line inputs";
extern int     TL_MaTdTF=10080;//Time frame defaults to W1
extern int     TL_MaTdPeriod=10;
extern int     TL_MaTdShift=0;//The MA Shift input
extern string  stmame="Method: 0=sma; 1=ema; 2=smma;  3=lwma";
extern int     TL_MaTdMethod=0;
extern string  stmaap="Applied price: 0=Close; 1=Open; 2=High";
extern string  stmaap1="3=Low; 4=Median; 5=Typical; 6=Weighted";
extern int     TL_MaTdAppliedPrice=0;
extern int     TlCompareWithCandles=5;
extern int     TlMinimumAcceptableMove=100;//Pure guesswork to make sure there has bee a decent movement in the ma

extern string  stm="Short-term momentum line inputs (SL)";
extern int     SL_Tf=240;
extern int     SL_FastMA=15;
extern int     SL_SlowMA=60;

extern string  itm="Intermediate-term MA of SL line inputs (IL)";
extern int     Il_Period=90;
extern int     IlCompareWithCandles=5;
//extern double  IlMinimumAcceptableMove=0.1;//Pure guesswork to make sure there has bee a decent movement in the ma

extern string  spr="----Spread----";
extern bool    ShowSpread=true;

extern string  pci="----Stats display inputs----";
extern int     FontSize=9;
extern color   PairColour=Yellow;
extern color   LongTrendColour=LimeGreen;
extern color   ShortTrendColour=Red;
extern color   RangingColour=Turquoise;
extern double  DisplayStartsAtRow=1;
extern double  RowSpacing=1;
extern double  DisplayStartsAtCol=100;
extern double  ColumnSpacing=50;
extern string  cols="Colours";

//Pair extraction
int		      NoOfPairs;				// Holds the number of pairs passed by the user via the inputs screen
string	      TradePair[];			//Array to hold the pairs traded by the user

//Trend detection
string         trend;

//MACD main - SL or short term momentum line
double         SL, PrevSL;
string         SlTrend;
//MACD signal - IL or intermediate line
double         IL, PrevIL;
string         IlTrend;
//Points count
double         LongPointsCount, ShortPointsCount;

//Misc
string   LabelPrefix;


//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
{
	//Extract the pairs traded by the user
	NoOfPairs = StringFindCount(PairsToTrade,",")+1;
	ArrayResize(TradePair, NoOfPairs);
	string AddChar = StringSubstr(Symbol(),6,4);
	StrPairToStringArray(PairsToTrade, TradePair, AddChar);

	LabelPrefix = "Trendy dashboard ";
   

}
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
{
//----
   RemoveObjects(LabelPrefix);

//----
   return(0);
}

//+------------------------------------------------------------------+
int StringFindCount(string str, string str2)
//+------------------------------------------------------------------+
// Returns the number of occurrences of STR2 in STR
// Usage:   int x = StringFindCount("ABCDEFGHIJKABACABB","AB")   returns x = 3
{
  int c = 0;
  for (int i=0; i<StringLen(str); i++)
    if (StringSubstr(str,i,StringLen(str2)) == str2)  c++;
  return(c);
} // End int StringFindCount(string str, string str2)

//+------------------------------------------------------------------+
void StrPairToStringArray(string str, string &a[], string p_suffix, string delim=",")
//+------------------------------------------------------------------+
{
	int z1=-1, z2=0;
	for (int i=0; i<ArraySize(a); i++)
	{
		z2 = StringFind(str,delim,z1+1);
		a[i] = StringSubstr(str,z1+1,z2-z1-1) + p_suffix;
		if (z2 >= StringLen(str)-1)   break;
		z1 = z2;
	}
	return(0);
}

//-------------------------------------------------------------------+
void RemoveObjects(string Pref)
//+------------------------------------------------------------------+
{   
	int i;
	string objname = "";

	for (i = ObjectsTotal(); i >= 0; i--)
	{
		objname = ObjectName(i);
		if (StringFind(objname, Pref, 0) > -1) ObjectDelete(objname);
	}
	return(0);
} // End void RemoveObjects(string Pref)

double AdaptMinAcceptableMove(string symbol)
{

   //Adapt to x digit criminals
   int multiplier;
   int digits = MarketInfo(symbol, MODE_DIGITS);
   if(digits == 2 || digits == 4) multiplier = 1;
   if(digits == 3 || digits == 5) multiplier = 10;
   if(digits == 6) multiplier = 100;   
   if(digits == 7) multiplier = 1000;   

   int number = TlMinimumAcceptableMove * multiplier;
   return(number);

}//double AdaptMinAcceptableMove()

//+------------------------------------------------------------------+
void GetSlIl(string symbol)
//+------------------------------------------------------------------+
{

   //Calculate SL
   SL = iMACD(symbol, SL_Tf, SL_FastMA, SL_SlowMA, Il_Period, PRICE_CLOSE, MODE_MAIN, 0);
   PrevSL = iMACD(symbol, SL_Tf, SL_FastMA, SL_SlowMA, Il_Period, PRICE_CLOSE, MODE_MAIN, 1);
   SlTrend = none;
   if (SL > PrevSL) SlTrend = up;
   if (SL < PrevSL) SlTrend = down;
   
   //Calculate IL
   IL = iMACD(symbol, SL_Tf, SL_FastMA, SL_SlowMA, Il_Period, PRICE_CLOSE, MODE_SIGNAL, 0);
   PrevIL = iMACD(symbol, SL_Tf, SL_FastMA, SL_SlowMA, Il_Period, PRICE_CLOSE, MODE_SIGNAL, IlCompareWithCandles);
   IlTrend = none;
   
   /*
   double pip;
   int pipMult,pipMultTab[]={1,10,1,10,1,10,100}; // multiplier to convert pips to Points;
   pipMult = pipMultTab[Digits];
   pip = Point * pipMult;
   */
   
   //if (IL > PrevIL &&  (IL - PrevIL) / pip >= IlMinimumAcceptableMove) IlTrend = up;
   //if (IL < PrevIL && (PrevIL - IL) / pip >= IlMinimumAcceptableMove) IlTrend = down;
   if (IL > PrevIL) IlTrend = up;
   if (IL < PrevIL) IlTrend = down;
   

}//void GetSlIl()

//+------------------------------------------------------------------+
void CalculatePoints()
//+------------------------------------------------------------------+
{
   
   LongPointsCount = 0;
   ShortPointsCount = 0;

   if (trend == up) LongPointsCount++;
   if (IlTrend == up) LongPointsCount+= 0.5;
   if (IL > 0) LongPointsCount+= 0.5;
   if (SlTrend == up) LongPointsCount++;
   
   if (trend == down) ShortPointsCount++;
   if (IlTrend == down) ShortPointsCount+= 0.5;
   if (IL < 0) ShortPointsCount+= 0.5;
   if (SlTrend == down) ShortPointsCount++;
   

}//End void CalculatePoints()

//+------------------------------------------------------------------+
void ShowStats()
//+------------------------------------------------------------------+
{
   //int x = 0;
   //while(x == 0)
   //{  
     //Displays pair-by-pair data in lables on the screen
	  RemoveObjects(LabelPrefix);

     double vertical;
     double horizontal;
     string Label_Name;
     int a;
   
     //Headings
     vertical = DisplayStartsAtCol;
     horizontal = DisplayStartsAtRow;
     Label_Name = LabelPrefix + "headlabel" + DoubleToStr(a, 0);
     Printtxt("Pair",Label_Name,FontSize,"Arial", PairColour,vertical,horizontal);
     vertical+= ColumnSpacing;
     a++;
   
     vertical = DisplayStartsAtCol + ColumnSpacing * 2;
     Label_Name = LabelPrefix + "headlabel" + DoubleToStr(a, 0);
     Printtxt("Trend",Label_Name,FontSize,"Arial", PairColour,vertical,horizontal);
     a++;
   
     vertical+= ColumnSpacing;
     Label_Name = LabelPrefix + "headlabel" + DoubleToStr(a, 0);
     Printtxt("+ count",Label_Name,FontSize,"Arial", PairColour,vertical,horizontal);
     a++;
   
     vertical+= ColumnSpacing;
     Label_Name = LabelPrefix + "headlabel" + DoubleToStr(a, 0);
     Printtxt("- count",Label_Name,FontSize,"Arial", PairColour,vertical,horizontal);
     a++;
   
     vertical+= ColumnSpacing;
     Label_Name = LabelPrefix + "headlabel" + DoubleToStr(a, 0);
     Printtxt("B swap",Label_Name,FontSize,"Arial", PairColour,vertical,horizontal);
     a++;
   
     vertical+= ColumnSpacing + 10;
     Label_Name = LabelPrefix + "headlabel" + DoubleToStr(a, 0);
     Printtxt("S swap",Label_Name,FontSize,"Arial", PairColour,vertical,horizontal);
     a++;
   
     if (ShowSpread)
     {
         vertical+= ColumnSpacing + 10;
         Label_Name = LabelPrefix + "headlabel" + DoubleToStr(a, 0);
         Printtxt("Spread",Label_Name,FontSize,"Arial", PairColour,vertical,horizontal);
         a++;
     }//if (ShowSpread)
     
   
 	  //Show Trade Pair
	  vertical = DisplayStartsAtCol;
     horizontal+= RowSpacing;
	  for(int i=0; i<NoOfPairs; i++)
	  {
        int digits = MarketInfo(TradePair[i], MODE_DIGITS);

		  if (iClose(TradePair[i], PERIOD_H1, 0) > 0)
		  {
           //Trend
           double point = MarketInfo(TradePair[i], MODE_POINT);
           trend = ranging;
           double TL = GetMa(TradePair[i], TL_MaTdTF, TL_MaTdPeriod, TL_MaTdShift, TL_MaTdMethod, TL_MaTdAppliedPrice, 0);   
           double PrevTL = GetMa(TradePair[i], TL_MaTdTF, TL_MaTdPeriod, TL_MaTdShift, TL_MaTdMethod, TL_MaTdAppliedPrice, TlCompareWithCandles);   
           int min = AdaptMinAcceptableMove(TradePair[i]);
           if (TL > PrevTL &&  TL - PrevTL >= (min * point) ) trend = up;
           if (TL < PrevTL &&  PrevTL - TL >= (min * point) ) trend = down;      
           bool ShowPair = true;
           if (trend == ranging && !ShowRangingPairs) ShowPair = false;
           
           if (ShowPair)
           {
               //vertical = Column: horizontal = Row
               vertical = DisplayStartsAtCol;
               Label_Name = LabelPrefix + DoubleToStr(i, 0) + "a";
               Printtxt(TradePair[i],Label_Name,FontSize,"Arial", PairColour,vertical,horizontal);
               //Show pair data
               vertical = DisplayStartsAtCol + ColumnSpacing * 2;
         

               color col = RangingColour;
               if (trend == up) col = LongTrendColour;
               if (trend == down) col = ShortTrendColour;
         
               Label_Name = LabelPrefix + DoubleToStr(i, 0) + DoubleToStr(a, 0);
               Printtxt(trend,Label_Name,FontSize,"Arial", col,vertical,horizontal);
               a++;
         
               //IL/SL readings and point count
               GetSlIl(TradePair[i]);
               CalculatePoints();
              //Positive, or Long readings
               vertical+= ColumnSpacing;
               Label_Name = LabelPrefix + DoubleToStr(i, 0) + DoubleToStr(a, 0);
               if (LongPointsCount >= 2)  
               {
                  col = LongTrendColour;
                  Printtxt(DoubleToStr(LongPointsCount, 1),Label_Name,FontSize,"Arial", col,vertical,horizontal);
               }//if (LongPointsCount > 0)           
               a++;
         
               //Negative, or Short readings
               vertical+= ColumnSpacing;
               Label_Name = LabelPrefix + DoubleToStr(i, 0) + DoubleToStr(a, 0);
               if (ShortPointsCount >= 2)  
               {
                  col = ShortTrendColour;
                  Printtxt(DoubleToStr(ShortPointsCount, 1),Label_Name,FontSize,"Arial", col,vertical,horizontal);
               }//if (LongPointsCount > 0)           
               a++;
         
               //Swap
               vertical+= ColumnSpacing;
               double swap = MarketInfo(TradePair[i], MODE_SWAPLONG);
               Label_Name = LabelPrefix + DoubleToStr(i, 0) + DoubleToStr(a, 0);
               if (swap > 0) col = LongTrendColour;
               if (swap < 0) col = ShortTrendColour;
               Printtxt(DoubleToStr(swap, 2),Label_Name,FontSize,"Arial", col,vertical,horizontal);
               a++;

               vertical+= ColumnSpacing + 10;
               swap = MarketInfo(TradePair[i], MODE_SWAPSHORT);
               Label_Name = LabelPrefix + DoubleToStr(i, 0) + DoubleToStr(a, 0);
               if (swap > 0) col = LongTrendColour;
               if (swap < 0) col = ShortTrendColour;
               Printtxt(DoubleToStr(swap, 2),Label_Name,FontSize,"Arial", col,vertical,horizontal);
               a++;

               if (ShowSpread)
               {
                   vertical+= ColumnSpacing + 10;
                   double spread = MarketInfo(TradePair[i], MODE_SPREAD);
                   Label_Name = LabelPrefix + DoubleToStr(i, 0) + DoubleToStr(a, 0);
                   Printtxt(DoubleToStr(spread,0),Label_Name,FontSize,"Arial", PairColour,vertical,horizontal);
                   vertical+= ColumnSpacing;
                   a++;
               }//if (ShowSpread)
           
               //New line
               horizontal+= RowSpacing;
            }//if (ShowPair)
           
	    }//if (iClose(TradePair[i], PERIOD_H1, 0) > 0)
		
     }//for(int i=0; i<NoOfPairs; i++)
     //Sleep(10000);
   //}//while(x == 0)
   
   
}//End void ShowStats()

void Printtxt(string text, string str,int size, string font, color vcolor, double vertical, double horizontal) 
{
   //if (ObjectFind(str) != 0)
   if (ObjectFind(str) == -1)
   {
      ObjectCreate(str, OBJ_LABEL, 0, 0, 0);      
   }
   ObjectSetText(str, text, size, font, vcolor);
   ObjectSet(str, OBJPROP_XDISTANCE, 0 + vertical);
   ObjectSet(str, OBJPROP_YDISTANCE, 0 + 14.0 * horizontal);
   //ObjectSet(str, OBJPROP_XDISTANCE, 0 + horizontal);
   //ObjectSet(str, OBJPROP_YDISTANCE, 0 + 14.0 * vertical);
   
}//End void Printtxt(string text, string str,int size, string font, color vcolor = -1, double vertical = -1.0, int horizontal = 0) {

double GetMa(string symbol, int tf, int period, int mashift, int method, int ap, int shift)
{
   return(iMA(symbol, tf, period, mashift, method, ap, shift) );
}//End double GetMa(int tf, int period, int mashift, int method, int ap, int shift)
  
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
{
   ShowStats();

}
//+------------------------------------------------------------------+